/*
 * Decompiled with CFR 0.152.
 */
package cds.fits;

import cds.aladin.Aladin;
import cds.allsky.CacheFitsWriter;
import cds.allsky.Context;
import cds.allsky.MyInputStreamCachedException;
import cds.fits.Fits;
import cds.tools.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class CacheFits {
    private static final long DELAYINCREASE = 300000L;
    private long timeLastIncrease = 0L;
    private static final long DEFAULT_MAXMEM = 0x20000000L;
    protected static final int DEFAULT_MAXFILE = 500;
    private long LIMITMEM;
    private int LIMITFILE;
    private long maxMem;
    private int maxFile;
    private long initMem;
    private int initFile;
    private int nextId;
    private volatile boolean cacheOutOfMem;
    protected HashMap<String, FitsFile> map;
    private int nbClean;
    private Context context;
    private Hashtable<String, double[]> cutCache = new Hashtable();
    private Hashtable<String, double[]> shapeCache = new Hashtable();
    protected int statNbOpen;
    protected int statNbFind;
    protected int statNbFree;
    protected static final Object lockObj = new Object();
    public static final int FITS = 0;
    public static final int JPEG = 1;
    public static final int PNG = 2;
    public static final int HHH = 4;
    private boolean firstChangeOrig = true;
    volatile boolean deja = false;
    protected static int WIDTHAUTOCUT = -1;
    protected static int HEIGHTAUTOCUT = -1;
    private boolean first = true;
    static double obscale = -1.0;
    static long lastTimeMem = 0L;
    static long lastMem = 0L;

    public CacheFits() {
        this(0x20000000L, 500, 0x60000000L, 1500);
    }

    public CacheFits(long maxMem) {
        this(maxMem, 500, 0x60000000L, 1500);
    }

    public CacheFits(long maxMem, int maxFile, long limitMem, int limitFile) {
        if (maxMem > limitMem) {
            maxMem = limitMem;
        }
        if (maxFile > limitFile) {
            maxFile = limitFile;
        }
        this.maxMem = this.initMem = maxMem;
        this.maxFile = this.initFile = maxFile;
        this.LIMITMEM = limitMem;
        this.LIMITFILE = limitFile;
        this.cacheOutOfMem = maxMem == 0L;
        this.nextId = 0;
        this.nbClean = 0;
        this.statNbFind = 0;
        this.statNbOpen = 0;
        this.statNbFree = 0;
        this.map = new HashMap(maxFile + maxFile / 2);
    }

    public long getMaxMem() {
        return this.maxMem;
    }

    public int getMaxFile() {
        return this.maxFile;
    }

    public Fits getFits(String fileName) throws Exception, MyInputStreamCachedException {
        return this.getFits(fileName, 0, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Fits getFits(String fileName, int mode, boolean flagLoad, boolean keepHeader) throws Exception, MyInputStreamCachedException {
        if (this.cacheOutOfMem) {
            return this.open((String)fileName, (int)mode, (boolean)flagLoad, (boolean)keepHeader).fits;
        }
        Object object = lockObj;
        synchronized (object) {
            FitsFile f = this.find(fileName);
            if (f != null) {
                f.update();
                ++this.statNbFind;
            } else {
                if (this.isOver()) {
                    this.clean();
                }
                try {
                    f = this.add(fileName, mode, flagLoad, keepHeader);
                }
                catch (OutOfMemoryError e) {
                    System.out.println("CacheFits.getFits(" + fileName + ") out of memory... clean and try again...");
                    this.maxMem = this.maxMem < 0L ? (this.maxMem *= 2L) : (this.maxMem /= 2L);
                    try {
                        this.clean();
                        f = this.add(fileName, mode, flagLoad, keepHeader);
                    }
                    catch (OutOfMemoryError e1) {
                        System.out.println("CacheFits.getFits(" + fileName + ") out of memory... double error... removing the cache...");
                        e1.printStackTrace();
                        this.reset();
                        this.cacheOutOfMem = true;
                        return this.open((String)fileName, (int)mode, (boolean)flagLoad, (boolean)keepHeader).fits;
                    }
                }
                ++this.statNbOpen;
            }
            return f.fits;
        }
    }

    protected FitsFile find(String name) {
        return this.map.get(name);
    }

    private FitsFile add(String name, int mode, boolean flagLoad, boolean keepHeader) throws Exception, MyInputStreamCachedException {
        FitsFile f = this.open(name, mode, flagLoad, keepHeader);
        this.map.put(name, f);
        return f;
    }

    protected void remove(String name) throws Exception {
        this.map.remove(name);
    }

    private String replaceExt(String filename, String orig, String ext) {
        int pos;
        if (orig == null) {
            orig = "";
        }
        if ((pos = filename.lastIndexOf("." + orig)) == -1) {
            return filename + "." + ext;
        }
        return filename.substring(0, pos) + "." + ext + filename.substring(pos + ("." + orig).length());
    }

    private void setAltBlank(Fits f) {
        if (this.context == null) {
            return;
        }
        if (this.context.getBlankKey() != null) {
            f.setBlank(this.context.getBlankKey());
        } else if (this.context.hasAlternateBlank()) {
            f.setBlank(this.context.getBlankOrig());
        }
    }

    private FitsFile open(String fileName, int mode, boolean flagLoad, boolean keepHeader) throws Exception, MyInputStreamCachedException {
        int deb;
        boolean flagChangeOrig = false;
        String file = fileName;
        int fin = file.length() - 1;
        if (file.charAt(fin) == ']' && (deb = file.lastIndexOf(91, fin)) > 0) {
            file = file.substring(0, deb);
        }
        if (!new File(file).exists()) {
            throw new FileNotFoundException();
        }
        FitsFile f = new FitsFile();
        f.fits = new Fits();
        if (this.context != null && (this.context.skyvalName != null || this.context.cutByImage)) {
            flagLoad = true;
            f.fits.setReleasable(false);
        }
        if ((mode & 4) != 0) {
            f.fits.loadHeaderFITS(fileName);
            this.setAltBlank(f.fits);
            String pngFile = this.replaceExt(fileName, "hhh", "png");
            String jpgFile = this.replaceExt(fileName, "hhh", "jpg");
            String fitsFile = this.replaceExt(fileName, "hhh", "fits");
            boolean modeSpecialFitsHHH = false;
            if ((mode & 3) == 0) {
                String racJpgFile = jpgFile;
                String racPngFile = pngFile;
                String racFitsFile = fitsFile;
                int i = jpgFile.indexOf(".jpg[");
                if (i > 0) {
                    racJpgFile = jpgFile.substring(0, i + 4);
                }
                if ((i = pngFile.indexOf(".png[")) > 0) {
                    racPngFile = pngFile.substring(0, i + 4);
                }
                if ((i = fitsFile.indexOf(".fits[")) > 0) {
                    racFitsFile = fitsFile.substring(0, i + 5);
                }
                if (new File(racJpgFile).exists()) {
                    mode |= 1;
                } else if (new File(racPngFile).exists()) {
                    mode |= 2;
                } else if (new File(racFitsFile).exists()) {
                    modeSpecialFitsHHH = true;
                }
            }
            if ((mode & 2) != 0) {
                fileName = pngFile;
            } else if ((mode & 1) != 0) {
                fileName = jpgFile;
            } else if (modeSpecialFitsHHH) {
                fileName = fitsFile;
            } else {
                throw new Exception(".hhh file without associated .jpg, .png or .fits file");
            }
        }
        if ((mode & 3) != 0) {
            int format = (mode & 2) != 0 ? 2 : ((mode & 1) != 0 ? 1 : 0);
            f.fits.loadPreview(fileName, true, (mode & 4) == 0, format);
        } else {
            f.fits.loadFITS(fileName, false, flagLoad, true);
            this.setAltBlank(f.fits);
            if (this.context != null) {
                boolean bl = flagChangeOrig = f.fits.bzero != this.context.bZeroOrig || f.fits.bscale != this.context.bScaleOrig;
                if (flagChangeOrig && this.firstChangeOrig) {
                    this.context.warning("All original data sets do no used the same BZERO & BSCALE factors => rescaling will be applied => " + fileName);
                    this.firstChangeOrig = false;
                }
                if (this.context.isCube()) {
                    int d = 1;
                    try {
                        d = f.fits.headerFits.getIntFromHeader("NAXIS3");
                        if (d != this.context.depth) {
                            throw new Exception();
                        }
                    }
                    catch (Exception e) {
                        throw new Exception("Uncompatible cube depth (" + d + ") => file ignored [" + f.fits.getFilename() + "]");
                    }
                    if (this.context.isCubeCanal()) {
                        try {
                            double crpix3 = f.fits.headerFits.getDoubleFromHeader("CRPIX3");
                            double crval3 = f.fits.headerFits.getDoubleFromHeader("CRVAL3");
                            double cdelt3 = f.fits.headerFits.getDoubleFromHeader("CDELT3");
                            if (this.context.crpix3 != crpix3 || this.context.crval3 != crval3 || this.context.cdelt3 != cdelt3) {
                                throw new Exception();
                            }
                        }
                        catch (Exception e) {
                            this.context.warning("All original data sets do no used the same CRPIX3,CRVAL3 & CDELT3 factors => factors ignored");
                            this.context.cdelt3 = 0.0;
                            this.context.crval3 = 0.0;
                            this.context.crpix3 = 0.0;
                            this.context.cunit3 = null;
                        }
                    }
                }
            }
        }
        if (this.context != null && (this.context.skyvalName != null || this.context.expTimeName != null || this.context.pixelGood != null || flagChangeOrig || this.context.dataArea != 0)) {
            this.applyPostFilter(f.fits, flagChangeOrig);
        }
        if (this.context != null && this.context.cutByImage) {
            this.applyTo8(f.fits);
        }
        if (!keepHeader) {
            f.fits.freeHeader();
        }
        return f;
    }

    protected boolean isOver() {
        if (this.map.size() > this.maxFile) {
            return true;
        }
        if (this.maxMem < 0L) {
            return CacheFits.getFreeMem() < -this.maxMem;
        }
        return this.getMem() > this.maxMem;
    }

    public long getMem() {
        long mem = 0L;
        if (this.map == null) {
            return mem;
        }
        try {
            for (FitsFile f : this.map.values()) {
                mem += f.fits.getMem();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceClean() {
        Object object = lockObj;
        synchronized (object) {
            this.clean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clean() {
        Object object = lockObj;
        synchronized (object) {
            int pass;
            boolean tooManyMem;
            long mem = this.getMem();
            long freeMem = CacheFits.getFreeMem();
            boolean tooManyFile = this.map.size() > this.maxFile;
            boolean bl = tooManyMem = this.maxMem < 0L && freeMem < -this.maxMem || this.maxMem >= 0L && mem > this.maxMem;
            if (!tooManyFile && !tooManyMem) {
                return;
            }
            long totMem = 0L;
            long m = 0L;
            int nb = 0;
            boolean encore = true;
            long now = Util.getTime(0);
            long delay = 5000L;
            boolean flagGC = false;
            try {
                this.cacheOutOfMem = true;
                HashMap<String, String> libere = new HashMap<String, String>(this.map.size());
                HashMap<String, FitsFile> map1 = new HashMap<String, FitsFile>(this.maxFile + this.maxFile / 2);
                for (pass = 0; pass < 2 && encore; ++pass) {
                    FitsFile f;
                    int mapsize = this.map.size();
                    for (String key : this.map.keySet()) {
                        f = this.map.get(key);
                        if (f.fits.hasUsers() || pass == 0 && now - f.timeAccess < delay) continue;
                        m = f.getMem();
                        ++this.statNbFree;
                        libere.put(key, "");
                        if ((totMem += m) <= mem / 3L || mapsize - ++nb >= 2 * this.maxFile / 3) continue;
                        encore = false;
                        break;
                    }
                    for (String key : this.map.keySet()) {
                        if (libere.get(key) != null) continue;
                        f = this.map.get(key);
                        map1.put(key, f);
                    }
                    if (this instanceof CacheFitsWriter) {
                        for (String key : libere.keySet()) {
                            try {
                                this.remove(key);
                            }
                            catch (Exception f2) {}
                        }
                    }
                    this.map = map1;
                }
                if (freeMem < mem / 2L) {
                    this.gc();
                    flagGC = true;
                }
            }
            finally {
                this.cacheOutOfMem = false;
            }
            long duree = Util.getTime(0) - now;
            String s1 = pass > 1 ? "s" : "";
            long freeRam = CacheFits.getFreeMem();
            ++this.nbClean;
            if (this.context != null) {
                CacheFits cacheFits = this;
                if (cacheFits.context.getVerbose() >= 3) {
                    String tps = duree > 1000L ? " in " + Util.getTemps(duree / 1000L) : "";
                    String p = pass > 1 ? " in " + pass + " steps" : "";
                    this.context.stat("Cache: freeRAM=" + Util.getUnitDisk(freeMem) + " => " + nb + " files released (" + Util.getUnitDisk(totMem) + ")" + p + s1 + tps + (flagGC ? " => freeRAM=" + Util.getUnitDisk(freeRam) : ""));
                }
            }
            now = System.currentTimeMillis();
            if (pass > 1) {
                if (this.increaseCache()) {
                    this.timeLastIncrease = now;
                }
            } else if (System.currentTimeMillis() - this.timeLastIncrease > 300000L) {
                this.decreaseCache();
            }
        }
    }

    private boolean increaseCache() {
        long maxMem2;
        if (this.maxFile >= this.LIMITFILE || this.maxMem >= this.LIMITMEM) {
            return false;
        }
        long memPerItem = this.maxMem / (long)this.maxFile;
        int maxFile2 = this.maxFile + this.maxFile / 2;
        if (maxFile2 > this.LIMITFILE) {
            maxFile2 = this.LIMITFILE;
        }
        if ((maxMem2 = (long)maxFile2 * memPerItem) > this.LIMITMEM) {
            // empty if block
        }
        this.maxFile = maxFile2;
        this.maxMem = maxMem2;
        if (this.context != null) {
            CacheFits cacheFits = this;
            if (cacheFits.context.getVerbose() >= 3) {
                this.context.stat("Cache: increaseCache: items=" + this.maxFile + " mem=" + Util.getUnitDisk(this.maxMem));
            }
        }
        return true;
    }

    private boolean decreaseCache() {
        long maxMem2;
        if (this.maxFile <= this.initFile || this.maxMem <= this.initMem) {
            return false;
        }
        int delay = 5000;
        long now = System.currentTimeMillis();
        int nb = 0;
        for (String key : this.map.keySet()) {
            FitsFile f = this.map.get(key);
            if (f.fits.hasUsers() || now - f.timeAccess < (long)delay || ++nb >= this.maxFile / 3) continue;
            return false;
        }
        long memPerItem = this.maxMem / (long)this.maxFile;
        int maxFile2 = this.maxFile - this.maxFile / 3;
        if (maxFile2 < this.initFile) {
            maxFile2 = this.initFile;
        }
        if ((maxMem2 = (long)maxFile2 * memPerItem) < this.initMem) {
            maxMem2 = this.initMem;
        }
        this.maxFile = maxFile2;
        this.maxMem = maxMem2;
        if (this.context != null) {
            CacheFits cacheFits = this;
            if (cacheFits.context.getVerbose() >= 3) {
                this.context.stat("Cache: decreaseCache: items=" + this.maxFile + " mem=" + Util.getUnitDisk(this.maxMem));
            }
        }
        return true;
    }

    public int getNbClean() {
        return this.nbClean;
    }

    public void reset() {
        this.statNbFree += this.map.size();
        if (this instanceof CacheFitsWriter) {
            ArrayList<String> a = new ArrayList<String>(this.map.size());
            for (String key : this.map.keySet()) {
                a.add(key);
            }
            for (String key : a) {
                try {
                    this.remove(key);
                }
                catch (Exception exception) {}
            }
        } else {
            this.map.clear();
        }
        this.gc();
    }

    public void close() {
        this.reset();
    }

    public void setContext(Context c) {
        this.context = c;
    }

    private double[] findAutocutRange(Fits f, double pourcentMin, double pourcentMax) throws Exception {
        String filename = f.getFilename() + f.getMefSuffix();
        double[] cut = this.cutCache.get(filename);
        if (cut != null) {
            return cut;
        }
        Object[] cut1 = new Cut[5];
        Fits f1 = new Fits();
        f1.loadHeaderFITS(filename);
        int width = f1.width;
        int height = f1.height;
        int od = -1;
        int oh = -1;
        int ow = -1;
        int oz = -1;
        int oy = -1;
        int ox = -1;
        try {
            double pcMin = pourcentMin;
            double pcMax = pourcentMax;
            if (pcMin == pcMax) {
                pcMin = 0.003;
                pcMax = 0.9995;
            }
            String eval = "from " + Util.getPourcent(pcMin) + " to " + Util.getPourcent(pcMax);
            if (WIDTHAUTOCUT == -1) {
                if (f1.width > 512 && f1.height > 512) {
                    WIDTHAUTOCUT = (int)((double)f1.width / 3.5);
                    if (WIDTHAUTOCUT > 1024) {
                        WIDTHAUTOCUT = 1024;
                    }
                    if ((HEIGHTAUTOCUT = (int)((double)f1.height / 3.5)) > 1024) {
                        HEIGHTAUTOCUT = 1024;
                    }
                    this.context.info("Cut estimation (" + eval + ") based on median on 5 regions (" + WIDTHAUTOCUT + "x" + HEIGHTAUTOCUT + " pixels)");
                } else {
                    WIDTHAUTOCUT = (int)((double)f1.width * 0.8);
                    HEIGHTAUTOCUT = (int)((double)f1.height * 0.8);
                    this.context.info("Cut estimation (" + eval + ") based on central region (" + WIDTHAUTOCUT + "x" + HEIGHTAUTOCUT + " pixels)");
                }
            }
            int w = f1.width > WIDTHAUTOCUT ? WIDTHAUTOCUT : f1.width;
            int h = f1.height > HEIGHTAUTOCUT ? HEIGHTAUTOCUT : f1.height;
            int d = f1.depth > 10 ? 10 : f1.depth;
            int x = f.width / 2 - w / 2;
            int y = f.height / 2 - h / 2;
            int z = f.depth / 3 - d / 3;
            ox = x;
            oy = y;
            oz = z;
            ow = w;
            oh = h;
            od = d;
            f1.loadFITS(f.getFilename(), f.ext, x, y, z, w, h, d);
            this.setAltBlank(f1);
            cut = f1.findAutocutRange(pourcentMin, pourcentMax);
            if (width > 3 * WIDTHAUTOCUT && height > 3 * WIDTHAUTOCUT) {
                int j;
                int gapx = (width - 2 * WIDTHAUTOCUT) / 3;
                int gapy = (height - 2 * HEIGHTAUTOCUT) / 3;
                for (int i = 0; i < 4; ++i) {
                    x = i == 0 || i == 2 ? gapx : width - WIDTHAUTOCUT - gapx;
                    y = i < 2 ? gapy : height - HEIGHTAUTOCUT - gapy;
                    f1.loadFITS(f.getFilename(), f.ext, x, y, z, w, h, d);
                    cut1[i] = new Cut();
                    ((Cut)cut1[i]).cut = f1.findAutocutRange(pourcentMin, pourcentMax);
                }
                cut1[4] = new Cut();
                cut1[4].cut = new double[cut.length];
                for (j = 0; j < cut.length; ++j) {
                    ((Cut)cut1[4]).cut[j] = cut[j];
                }
                Arrays.sort(cut1);
                for (j = 0; j < cut.length; ++j) {
                    cut[j] = ((Cut)cut1[2]).cut[j];
                }
            }
        }
        catch (Exception e) {
            System.err.println("findAutocutRange exception: on " + filename + " width=" + width + " height=" + height + " box=" + ox + "," + oy + "," + oz + " " + ow + "x" + oh + "x" + od);
            e.printStackTrace();
            throw e;
        }
        this.cutCache.put(filename, cut);
        return cut;
    }

    private String ip(double raw, double bzero, double bscale) {
        return Util.myRound(raw) + (bzero != 0.0 || bscale != 1.0 ? "/" + Util.myRound(raw * bscale + bzero) : "");
    }

    private double[] findDataArea(Fits f) throws Exception {
        String filename = f.getFilename() + f.getMefSuffix();
        double[] shape = this.shapeCache.get(filename);
        if (shape != null) {
            return shape;
        }
        Fits f1 = new Fits();
        f1.loadFITS(filename);
        this.setAltBlank(f1);
        shape = f1.findData();
        this.shapeCache.put(filename, shape);
        return shape;
    }

    private void applyTo8(Fits f) throws Exception {
        double pourcentMin = 0.003;
        double pourcentMax = 0.9995;
        if (Context.hasPourcentCut(this.context.getPixelRangeCut())) {
            pourcentMin = this.context.getPixelRangeCut()[5];
            pourcentMax = this.context.getPixelRangeCut()[6];
        }
        double[] cut = this.findAutocutRange(f, pourcentMin, pourcentMax);
        byte[] pix8 = f.toPix8(cut[0], cut[1], null, 4);
        Fits.invImageLine(f.width, f.height, pix8);
        f.bitpix = 8;
        f.setBlank(0.0);
        f.setBscale(1.0);
        f.setBzero(0.0);
        f.pixels = pix8;
    }

    private void applyPostFilter(Fits f, boolean flagChangeOrig) {
        double skyval = 0.0;
        double expTime = 1.0;
        boolean skyValTag = false;
        boolean expTimeTag = false;
        double[] shape = null;
        double marge = 0.0;
        boolean flagAuto = true;
        double pourcentMin = this.context.pourcentMin;
        double pourcentMax = this.context.pourcentMax;
        if (this.context.skyvalName != null) {
            try {
                block32: {
                    if (this.context.skyvalName.equalsIgnoreCase("auto")) {
                        double[] cut = this.findAutocutRange(f, pourcentMin, pourcentMax);
                        double[] cutOrig = this.context.getCutOrig();
                        skyval = cut[0] - cutOrig[0];
                    } else {
                        try {
                            skyval = f.headerFits.getDoubleFromHeader(this.context.skyvalName);
                            double[] cutOrig = this.context.getCutOrig();
                            double refSkyVal = cutOrig[0] * this.context.bScaleOrig + this.context.bZeroOrig;
                            skyval -= refSkyVal;
                            skyval = (skyval - f.bzero) / f.bscale;
                            flagAuto = false;
                        }
                        catch (Exception e) {
                            double[] cut = this.findAutocutRange(f, pourcentMin, pourcentMax);
                            double[] cutOrig = this.context.getCutOrig();
                            skyval = cut[0] - cutOrig[0];
                            if (!this.first) break block32;
                            this.context.warning("\nSKYVAL=" + this.context.skyvalName + " not found is some images => use an estimation for these images");
                            this.first = false;
                        }
                    }
                }
                skyValTag = skyval != 0.0;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.context.dataArea != 0) {
            try {
                shape = this.findDataArea(f);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.context.expTimeName != null) {
            try {
                expTime = f.headerFits.getDoubleFromHeader(this.context.expTimeName);
                expTimeTag = expTime != 1.0;
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        if (!(skyValTag || expTimeTag || flagChangeOrig || this.context.pixelGood != null || shape != null)) {
            return;
        }
        if (skyValTag) {
            Aladin.trace(4, "SkyVal=" + skyval + (flagAuto ? "( estimation)" : "( from header)") + " => " + f.getFileNameExtended());
        }
        double blank = this.context.hasAlternateBlank() ? this.context.getBlankOrig() : f.blank;
        double a2 = 0.0;
        double b2 = 0.0;
        if (shape != null) {
            if (this.context.dataArea == 1) {
                a2 = shape[2] - (double)this.context.borderSize[0] - (double)this.context.borderSize[2];
                a2 *= a2;
                b2 = shape[3] - (double)this.context.borderSize[1] - (double)this.context.borderSize[3];
                b2 *= b2;
            } else {
                a2 = (shape[2] - (double)this.context.borderSize[0] - (double)this.context.borderSize[2]) / 2.0;
                b2 = (shape[3] - (double)this.context.borderSize[1] - (double)this.context.borderSize[3]) / 2.0;
            }
        }
        for (int z = 0; z < f.depthCell; ++z) {
            for (int y = 0; y < f.heightCell; ++y) {
                for (int x = 0; x < f.widthCell; ++x) {
                    double pixelFull = f.getPixelDouble(x + f.xCell, y + f.yCell, z + f.zCell);
                    if (Double.isNaN(pixelFull)) continue;
                    if (this.context.good != null && (pixelFull < this.context.good[0] || this.context.good[1] < pixelFull)) {
                        if (f.bitpix < 0) {
                            f.setPixelDouble(x + f.xCell, y + f.yCell, z + f.zCell, blank);
                            continue;
                        }
                        f.setPixelInt(x + f.xCell, y + f.yCell, z + f.zCell, (int)blank);
                        continue;
                    }
                    if (shape != null) {
                        boolean out;
                        double x1 = (double)(x + f.xCell) - shape[0];
                        double y1 = (double)(y + f.yCell) - shape[1];
                        if (this.context.dataArea == 1) {
                            out = x1 * x1 / a2 + y1 * y1 / b2 >= 1.0;
                        } else {
                            boolean bl = out = Math.abs(x1) >= a2 || Math.abs(y1) >= b2;
                        }
                        if (out) {
                            if (f.bitpix < 0) {
                                f.setPixelDouble(x + f.xCell, y + f.yCell, z + f.zCell, blank);
                                continue;
                            }
                            f.setPixelInt(x + f.xCell, y + f.yCell, z + f.zCell, (int)blank);
                            continue;
                        }
                    }
                    if (!this.context.hasAlternateBlank() ? f.isBlankPixel(pixelFull) : pixelFull == this.context.getBlankOrig()) continue;
                    if (skyValTag) {
                        pixelFull -= skyval;
                    }
                    if (expTimeTag) {
                        pixelFull /= expTime;
                    }
                    if (flagChangeOrig) {
                        pixelFull = pixelFull * f.bscale + f.bzero;
                        pixelFull = (pixelFull - this.context.bZeroOrig) / this.context.bScaleOrig;
                    }
                    if (f.bitpix < 0) {
                        f.setPixelDouble(x + f.xCell, y + f.yCell, z + f.zCell, pixelFull);
                        continue;
                    }
                    f.setPixelInt(x + f.xCell, y + f.yCell, z + f.zCell, (int)(pixelFull + 0.5));
                }
            }
        }
    }

    public int getStatNbOpen() {
        return this.statNbOpen;
    }

    public int getStatNbFind() {
        return this.statNbFind;
    }

    public int getStatNbFree() {
        return this.statNbFree;
    }

    public String toString() {
        int n = this.map.size();
        String s = n > 1 ? "s" : "";
        return "RAM cache: " + n + " item" + s + "/" + this.maxFile + " using " + Util.getUnitDisk(this.getMem()) + (this.maxMem > 0L ? "/" + Util.getUnitDisk(this.maxMem) : "[" + Util.getUnitDisk(this.maxMem) + "]") + " freeRAM=" + Util.getUnitDisk(CacheFits.getFreeMem()) + " (opened=" + this.statNbOpen + " reused=" + this.statNbFind + " released=" + this.statNbFree + (this.nbClean > 0 ? " [flush:" + this.nbClean + "x]" : "") + ")";
    }

    public static long getFreeMem() {
        lastMem = Runtime.getRuntime().maxMemory() - (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
        return lastMem;
    }

    public void gc() {
        System.gc();
        Util.pause(100);
    }

    protected class FitsFile {
        public Fits fits;
        long timeAccess = System.currentTimeMillis();
        private int id;

        public int hashCode() {
            return Integer.hashCode(this.id);
        }

        public FitsFile() {
            this.id = CacheFits.this.nextId++;
        }

        public long getMem() {
            if (this.fits == null) {
                return 0L;
            }
            return this.fits.getMem();
        }

        void update() {
            this.timeAccess = System.currentTimeMillis();
        }

        public String toString() {
            long now = System.currentTimeMillis();
            return "[" + this.id + "] age=" + (now - this.timeAccess) + " => " + this.fits.getFileNameExtended();
        }
    }

    class Cut
    implements Comparable<Cut> {
        double[] cut;

        Cut() {
        }

        @Override
        public int compareTo(Cut o) {
            return o.cut[0] < this.cut[0] ? -1 : (o.cut[0] > this.cut[0] ? 1 : 0);
        }
    }

    class ValueComparator
    implements Comparator {
        Map base;

        public ValueComparator(Map base) {
            this.base = base;
        }

        public int compare(Object a, Object b) {
            FitsFile a1 = (FitsFile)this.base.get(a);
            FitsFile b1 = (FitsFile)this.base.get(b);
            if (a1 == null) {
                return 1;
            }
            if (b1 == null) {
                return -1;
            }
            int val = (int)(b1.timeAccess + (long)b1.id - a1.timeAccess);
            if (val == 0) {
                return b1.id - a1.id;
            }
            return val;
        }
    }
}

